using System;
using Server;

namespace Xanthos.Evo
{
	public sealed class EvoDolphinSpec : BaseEvoSpec
	{
		// This class implements a singleton pattern; meaning that no matter how many times the
		// Instance attribute is used, there will only ever be one of these created in the entire system.
		// Copy this template and give it a new name.  Assign all of the data members of the EvoSpec
		// base class in the constructor.  Your subclass must not be abstract.
		// Never call new on this class, use the Instance attribute to get the instance instead.

		EvoDolphinSpec()
		{
			m_Tamable = true;
			m_MinTamingToHatch = 0;
			m_PercentFemaleChance = 0.00;	// Made small to limit access to eggs.
			m_GuardianEggOrDeedChance = 0.00;
			m_AlwaysHappy = true;
			m_ProducesYoung = false;
			m_AbsoluteStatValues = true;
			m_MaxEvoResistance = 90;
			m_MaxTrainingStage = 3;
			m_CanAttackPlayers = false;

			m_RandomHues = new int[] { 2101, 2102, 2103, 2104, 2105, 2106, 2107, 2108, 2109, 2110, 2111, 2112, 2113, 2114, 2115, 2116, 2117, 2118, 2119, 2120, 2121, 2122, 2123, 2124, 2125, 2126, 2127, 2128, 2129, 2130, 1281, 1283, 1285, 1378, 1369, 1266 };

			m_Skills = new SkillName[9] { SkillName.Magery, SkillName.EvalInt, SkillName.Meditation, SkillName.MagicResist,
										  SkillName.Tactics, SkillName.Wrestling, SkillName.Anatomy, SkillName.AnimalLore, SkillName.Healing };
			m_MinSkillValues = new int[9] { 40, 40, 40, 40, 40, 40, 40, 40, 40 };
			m_MaxSkillValues = new int[9] { 100, 100, 100, 100, 100, 100, 100, 100, 100 };

			m_Stages = new BaseEvoStage[] { new EvoDolphinStageOne(), new EvoDolphinStageTwo(),
											  new EvoDolphinStageThree(), new EvoDolphinStageFour(),
											  new EvoDolphinStageFive(), new EvoDolphinStageSix(),
											  new EvoDolphinStageSeven() };
		}

		// These next 2 lines facilitate the singleton pattern.  In your subclass only change the
		// BaseEvoSpec class name to your subclass of BaseEvoSpec class name and uncomment both lines.
		public static EvoDolphinSpec Instance { get { return Nested.instance; } }
		class Nested { static Nested() { } internal static readonly EvoDolphinSpec instance = new EvoDolphinSpec();}
	}	

	// Define a subclass of BaseEvoStage for each stage in your creature and place them in the
	// array in your subclass of BaseEvoSpec.  See the example classes for how to do this.
	// Your subclass must not be abstract.

	public class EvoDolphinStageOne : BaseEvoStage
	{
		public EvoDolphinStageOne()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 100000;
			ControlSlots = 3; VirtualArmor = 130;
			Hue = Evo.Flags.kRandomHueFlag;

			DamagesTypes = new ResistanceType[1] { ResistanceType.Physical };
			MinDamages = new int[1] { 100 };
			MaxDamages = new int[1] { 100 };

			ResistanceTypes = new ResistanceType[1] { ResistanceType.Physical };
			MinResistances = new int[1] { 30 };
			MaxResistances = new int[1] { 30 };

			DamageMin = 13; DamageMax = 18; HitsMin = 750; HitsMax = 750;
			StrMin = 300; StrMax = 300; DexMin = 70; DexMax = 70; IntMin = 300; IntMax = 300;
		}
	}

	public class EvoDolphinStageTwo : BaseEvoStage
	{
		public EvoDolphinStageTwo()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 200000;
			VirtualArmor = 140;
		
			DamagesTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
													ResistanceType.Poison, ResistanceType.Energy };
			MinDamages = new int[5] { 20, 20, 20, 20, 20 };
			MaxDamages = new int[5] { 20, 20, 20, 20, 20 };

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 40, 40, 40, 40, 40 };
			MaxResistances = new int[5] { 40, 40, 40, 40, 40 };

			DamageMin = 14; DamageMax = 20; HitsMin= 1000; HitsMax = 1000;
			StrMin = 400; StrMax = 400; DexMin = 80; DexMax = 80; IntMin = 400; IntMax = 400;
		}
	}

	public class EvoDolphinStageThree : BaseEvoStage
	{
		public EvoDolphinStageThree()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 400000;
         VirtualArmor = 150;
		
			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 50, 50, 50, 50, 50 };
			MaxResistances = new int[5] { 50, 50, 50, 50, 50 };

			DamageMin = 15; DamageMax = 22; HitsMin= 1300; HitsMax = 1300;
			StrMin = 500; StrMax = 500; DexMin = 100; DexMax = 100; IntMin = 500; IntMax = 500;
		}
	}

	public class EvoDolphinStageFour : BaseEvoStage
	{
		public EvoDolphinStageFour()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 800000;
			ControlSlots = 4; VirtualArmor = 160;
		
			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 60, 60, 60, 60, 60 };
			MaxResistances = new int[5] { 60, 60, 60, 60, 60 };	

			DamageMin = 17; DamageMax = 24; HitsMin= 1500; HitsMax = 1500;
			StrMin = 600; StrMax = 600; DexMin = 110; DexMax = 110; IntMin = 600; IntMax = 600;
		}
	}

	public class EvoDolphinStageFive : BaseEvoStage
	{
		public EvoDolphinStageFive()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 1600000;
			VirtualArmor = 170;

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 70, 70, 70, 70, 70 };
			MaxResistances = new int[5] { 70, 70, 70, 70, 70 };	

			DamageMin = 18; DamageMax = 25; HitsMin= 1700; HitsMax = 1700;
			StrMin = 700; StrMax = 700; DexMin = 130; DexMax = 130; IntMin = 700; IntMax = 700;
		}
	}

	public class EvoDolphinStageSix : BaseEvoStage
	{
		public EvoDolphinStageSix()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 3200000;
			VirtualArmor = 190;

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 80, 80, 80, 80, 80 };
			MaxResistances = new int[5] { 80, 80, 80, 80, 80 };	

			DamageMin = 20; DamageMax = 27; HitsMin= 2000; HitsMax = 2000;
			StrMin = 800; StrMax = 800; DexMin = 150; DexMax = 150; IntMin = 800; IntMax = 800;
		}
	}

	public class EvoDolphinStageSeven : BaseEvoStage
	{
		public EvoDolphinStageSeven()
		{
			EvolutionMessage = "has evolved to its highest form";
			NextEpThreshold = 0;
         ControlSlots = 4; VirtualArmor = 270;

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 90, 90, 90, 90, 90 };
			MaxResistances = new int[5] { 90, 90, 90, 90, 90 };	

			DamageMin = 23; DamageMax = 30; HitsMin= 2500; HitsMax = 2500;
			StrMin = 900; StrMax = 900; DexMin = 180; DexMax = 180; IntMin = 900; IntMax = 900;
		}
	}
}